//
// Mode class for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include "Core/Mode.h"
#include "Core/Error.h"
#include "Core/Config.h"




DLLAPI PTCAPI Mode::Mode()
{
    // defaults
    m_valid = false;
    m_width = 0;
    m_height = 0;
}


DLLAPI PTCAPI Mode::Mode(int width,int height,const Format &format)
{
    // setup data
    m_valid = true;
    m_width = width;
    m_height = height;
    m_format = format;
}


DLLAPI PTCAPI Mode::Mode(const Mode &mode)
{
    // assignment
    *this = mode;
}


DLLAPI PTCAPI Mode::~Mode()
{
    // destructor
}




DLLAPI bool PTCAPI Mode::valid() const
{
    // get valid flag
    return m_valid;
}




DLLAPI int PTCAPI Mode::width() const
{
    // check
    check();

    // get width
    return m_width;
}


DLLAPI int PTCAPI Mode::height() const
{
    // check
    check();

    // get height
    return m_height;
}


DLLAPI const Format& PTCAPI Mode::format() const
{
    // check
    check();

    // get format
    return m_format;
}




DLLAPI Mode& PTCAPI Mode::operator =(const Mode &mode)
{
    // check for self assignment
    if (this==&mode) throw Error("self assignment is not allowed");
        
    // assignment
    m_valid = mode.m_valid;
    m_width = mode.m_width;
    m_height = mode.m_height;
    m_format = mode.m_format;
    return *this;
}


DLLAPI bool PTCAPI Mode::operator ==(const Mode &mode) const
{
    // equal to
    if (m_valid==mode.m_valid && 
        m_width==mode.m_width && 
        m_height==mode.m_height && 
        m_format==mode.m_format) return true;

    // failure
    return false;
}


DLLAPI bool PTCAPI Mode::operator !=(const Mode &mode) const
{
    // not equal to
    return !(*this==mode);
}




void Mode::check() const
{
    #ifdef __DEBUG__

        // check that mode is valid
        if (!m_valid) throw Error("mode is not valid");

    #else

        // no checking in release build

    #endif
}
