//
// Area class for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_AREA_H
#define __PTC_AREA_H

// include files
#include "Core/Types.h"
#include "Core/Config.h"




class Area
{
    public:

        // setup
        DLLAPI PTCAPI Area();
        DLLAPI PTCAPI Area(int left,int top,int right,int bottom);
        DLLAPI PTCAPI Area(const Area &area);
        DLLAPI PTCAPI ~Area();

        // data access
        DLLAPI int PTCAPI left()   const;
        DLLAPI int PTCAPI right()  const;
        DLLAPI int PTCAPI top()    const;
        DLLAPI int PTCAPI bottom() const;
        DLLAPI int PTCAPI width()  const;
        DLLAPI int PTCAPI height() const;

        // operators
        DLLAPI Area& PTCAPI operator =(const Area &area);
        DLLAPI bool PTCAPI operator ==(const Area &area) const;
        DLLAPI bool PTCAPI operator !=(const Area &area) const;

    private:

        // data
        int m_left;
        int m_right;
        int m_top;
        int m_bottom;
};




#endif
