//
// Format class for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

#ifndef __PTC_FORMAT_H
#define __PTC_FORMAT_H

// include files
#include "Copy.h"
#include "Types.h"
#include "Clear.h"
#include "Hermes.h"




class Format
{
    public:

        // setup
        Format();
        Format(int bits);
        Format(int bits,int32 r,int32 g,int32 b,int32 a=0);
        Format(const Format &format);
        ~Format();

        // data access
        int32 r() const;
        int32 g() const;
        int32 b() const;
        int32 a() const;
        int bits() const;
        int bytes() const;
        bool direct() const;
        bool indexed() const;

        // operators
        Format& operator =(const Format &format);
        bool operator ==(const Format &format) const;
        bool operator !=(const Format &format) const;

    private:

        // hermes format
        HermesFormat m_format;

        // friend functions
        friend void Clear::request(const Format &format);
        friend void Copy::request(const Format &source,const Format &destination);
};




#endif
