;
; X86 fakemode routines for DOS PTC
; Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
; Adapted for use in PTC 2.0 C++ API by Jonathan Matthew (jmatthew@uq.net.au)
; This source code is licensed under the GNU LGPL
;

BITS 32

GLOBAL _PlaneBlt2_RBG

SECTION .text

;; Parameters:
;; edx - # rows
;; esi - source
;; edi - dest
;; returns updated dest in edi

_PlaneBlt2_RBG:

    push    ebp

.L1     mov     ebp, 20
        push    edx

.L2         mov     cl, [esi]
            mov     ch, [esi+8]
            shl     ecx, 16
            mov     cl, [esi+16]
            mov     ch, [esi+24]            ; low greens in ecx
            mov     ebx, ecx                ; blues in ebx
            and     ecx, 0c0c0c0c0h
            ror     ecx, 16+6

            mov     dl, [esi+1]
            mov     dh, [esi+9]
            shl     edx, 16
            mov     dl, [esi+17]
            mov     dh, [esi+25]            ; high greens in edx
            mov     eax, edx                ; reds in eax
            and     edx, 07070707h
            ror     edx, 16-2

            and     ebx, 1c1c1c1ch
            ror     ebx, 16+2

            and     eax, 0f0f0f0f0h
            ror     eax, 16+1

            add     eax, ebx                ; eax = red+blue
            add     ecx, edx                ; ecx = green

            or      ecx, 80808080h

            mov     [edi], eax
            mov     [edi+80], ecx

            add     esi, 4*4*2
            add     edi, 4

            dec     ebp
            jnz     .L2

        pop     edx
        add     edi, 80

        dec     edx
        jnz     .L1

.L3 pop     ebp
    ret

