//
// Base classes for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_BASE_H
#define __PTC_BASE_H

// include files
#include "Index.h"
#include "Types.h"




class BaseSurface
{
    public:

        // virtual destructor
        virtual ~BaseSurface() {};

        // copy to surface
        virtual void copy(BaseSurface &surface) = 0;
        virtual void copy(BaseSurface &surface,const Area &source,const Area &destination) = 0;

        // memory access
        virtual void* lock() = 0;
        virtual void unlock() = 0;

        // load pixels to surface
        virtual void load(const void *pixels,int width,int height,const Format &format,const int32 palette[]) = 0;
        virtual void load(const void *pixels,int width,int height,const Area &source,const Area &destination,const Format &format,const int32 palette[]) = 0;

        // save surface pixels
        virtual void save(void *pixels,int width,int height,const Format &format,const int32 palette[]) = 0;
        virtual void save(void *pixels,int width,int height,const Area &source,const Area &destination,const Format &format,const int32 palette[]) = 0;

        // clear surface
        virtual void clear(const Color &color) = 0;
        virtual void clear(const Color &color,const Area &area) = 0;

        // surface palette
        virtual void palette(const int32 palette[]) = 0;
        virtual const int32* palette() = 0;

        // data access
        virtual int width() const = 0;
        virtual int height() const = 0;
        virtual int pitch() const = 0;
        virtual const Format& format() const = 0;
};




class BaseConsole : public BaseSurface
{
    public:

        // virtual destructor
        virtual ~BaseConsole() {};

        // console option string
        virtual bool option(const char string[]) = 0;

        // console management
        virtual void open(const char title[],const Format &format) = 0;
        virtual void open(const char title[],int width,int height,const Format &format) = 0;
        virtual void close() = 0;

        // synchronization
        virtual void update() = 0;
        virtual void update(const Area &area) = 0;

        // keyboard input
        virtual bool key() = 0;
        virtual int read() = 0;

        // data access
        virtual const char* name() const = 0;
};




#endif
