//
// Primary class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_PRIMARY_H
#define __PTC_PRIMARY_H

// include files
#include <ddraw.h>
#include "Copy/Copy.h"
#include "Base/Types.h"
#include "Core/Format.h"




namespace ptc
{
    namespace DirectX
    {
        class Primary
        {
            public:

                // setup
                Primary(LPDIRECTDRAW ddraw,bool indexed,int pages,bool video);
                ~Primary();

                // synchronization
                void update();

                // pixel operations
                void write(void *pixels,int width,int height,const Base::Format &format,int32 palette[]);

                // memory
                void* lock();
                void unlock();

                // palette
                void palette(int32 palette[]);

                // access
                int width();
                int height();
                int pitch();
                const ptc::Base::Format& format();

            private:

                // pixel format translation
                Core::Format translate(DDPIXELFORMAT const &ddpf);

                // close
                void close();

                // data
                int m_pages;
                int m_width;
                int m_height;
                Core::Format m_format;

                // copy object
                Copy m_copy;

                // directx interfaces
                LPDIRECTDRAW m_ddraw;
                LPDIRECTDRAWSURFACE m_back;
                LPDIRECTDRAWSURFACE m_front;
                LPDIRECTDRAWPALETTE m_palette;
                
                // surface interface array
                LPDIRECTDRAWSURFACE *m_surface;
        };
    }
}




#endif
