//
// DirectX Library class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include "Core/Error.h"
#include "DirectX/Check.h"
#include "DirectX/Library.h"

// using directive
using namespace ptc::DirectX;

// using declarations
using ptc::Core::Error;




Library::Library()
{
    // defaults
    m_ddraw   = 0;
    m_library = 0;
    
    try
    {
        // load "ddraw.dll"
        m_library = (HMODULE)LoadLibrary("ddraw.dll");
        if (!m_library) throw Error("could not load ddraw.dll");

        // "DirectDrawCreate" function pointer type
        typedef HRESULT (WINAPI *FUNCTION) (GUID FAR *lpGUID,LPDIRECTDRAW FAR *lplpDD,IUnknown FAR *pUnkOuter);

        // get directdraw create function address
        FUNCTION DirectDrawCreate = (FUNCTION) GetProcAddress(m_library,"DirectDrawCreate");
        if (!DirectDrawCreate) throw Error("could not get address of DirectDrawCreate");

        // create directdraw object
        check(DirectDrawCreate(0,&m_ddraw,0));
    }
    catch (Error &error)
    {
        // close
        close();

        // rethrow
        error.rethrow("could not initialize ddraw");
    }
}


Library::~Library()
{
    // close
    close();
}




void Library::close()
{
    // release directdraw interface
    if (m_ddraw) m_ddraw->Release();

    // free library module
    if (m_library) FreeLibrary(m_library);
}




LPDIRECTDRAW Library::lpDD()
{
    // get lpDD
    return m_ddraw;
}
