//
// DirectX Display class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_DIRECTX_DISPLAY_H
#define __PTC_DIRECTX_DISPLAY_H

// include files
#include <ddraw.h>
#include "Base/Format.h"




namespace ptc
{
    namespace DirectX
    {
        class Display
        {
            public:

                // constructor and destructor
                Display(LPDIRECTDRAW ddraw);
                ~Display();

                // display management
                void test(const char title[],int width,int height,const Base::Format &format);
                void open(HWND window,const char title[],int width,int height,const Base::Format &format);
                void close();

            private:

                // data
                bool m_open;
                HWND m_window;
                LPDIRECTDRAW m_ddraw;
        };
    }
}




#endif
