//
// Core Console implementation for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include "Core/Error.h"
#include "Core/Console.h"
#include "DirectX/Console.h"

// using directive
using namespace ptc::Core;

// using declarations
using ptc::Core::Error;




Console::Console()
{
    // defaults
    console = 0;
}


Console::Console(const char title[],int width,int height,const ptc::Base::Format &format)
{
    // defaults
    console = 0;

    // open console
    open(title,width,height,format);
}


Console::~Console()
{
    // close
    close();
}




void Console::open(const char title[],int width,int height,const ptc::Base::Format &format)
{
    try
    {
        // close
        close();
        
        // create new console
        console = new ptc::DirectX::Console(title,width,height,format);
    }
    catch (Error &error)
    {
        // close
        close();

        // error message
        error.rethrow("could not open console");
    }
}


void Console::close()
{
    // close console
    delete console;
    console = 0;
}




void Console::update()
{
    // update console
    console->update();
}




void Console::write(void *pixels,int width,int height,const ptc::Base::Format &format,int32 palette[])
{
    // write pixels to console
    console->write(pixels,width,height,format,palette);
}




bool Console::key()
{
    // check for keypress
    return console->key();
}


int Console::read()
{
    // read keypress
    return console->read();
}




void Console::copy(ptc::Base::Surface &surface)
{
    // copy to surface
    console->copy(surface);
}




void* Console::lock()
{
    // lock console
    return console->lock();
}


void Console::unlock()
{
    // unlock console
    console->unlock();
}




void Console::palette(int32 palette[])
{
    // set palette
    console->palette(palette);
}




int Console::width()
{
    // get width
    return console->width();
}


int Console::height()
{
    // get height
    return console->height();
}


int Console::pitch()
{
    // get pitch
    return console->pitch();
}


const ptc::Base::Format& Console::format()
{
    // get format
    return console->format();
}


const char* Console::name()
{
    // get name
    return console->name();
}
