//
// Copy class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_COPY_H
#define __PTC_COPY_H

// include files
#include "Base/Types.h"
#include "Base/Format.h"
#include "Core/Format.h"




class Copy
{
    public:

        // setup
        Copy();
        Copy(const ptc::Base::Format &source,const ptc::Base::Format &destination);
        ~Copy();

        // set pixel formats
        void formats(const ptc::Base::Format &source,const ptc::Base::Format &destination);

        // set source palette
        void palette(int32 palette[]);

        // copy pixels
        void copy(void *s_pixels,int s_x,int s_y,int s_width,int s_height,int s_pitch,
                  void *d_pixels,int d_x,int d_y,int d_width,int d_height,int d_pitch);

    private:

        // forward
        struct Field;

        // convert function typedef
        typedef void (*Function)(Copy &copy,void *source,void *destination,unsigned count);

        // utility functions
        void setup(const ptc::Base::Format &source,const ptc::Base::Format &destination);
        Field field(int32 source,int32 destination);
        void analyse(int32 mask,int &base,int &size);
        Copy::Function Copy::function(const ptc::Base::Format &source,const ptc::Base::Format &destination);

    protected:

        // utility routines
        static inline int32 read_24(char8 *source);
        static inline void write_24(char8 *destination,int32 pixel);
            
        // pixel conversion
        static inline void convert_pixel(Copy &copy,int32 &pixel);

        // copy conversion
        static void convert_copy(Copy &copy,void *source,void *destination,unsigned count);

        // muhmuh color converters
        static void convert_muhmuh32_direct32_rgb888(Copy &copy,void *source,void *destination,unsigned count);
        static void convert_muhmuh32_direct24_rgb888(Copy &copy,void *source,void *destination,unsigned count);
        static void convert_muhmuh32_direct16_rgb565(Copy &copy,void *source,void *destination,unsigned count);
        static void convert_muhmuh32_direct16_rgb555(Copy &copy,void *source,void *destination,unsigned count);
        
        // direct color to direct color conversion (rgba)
        static void convert_direct32_direct32_rgba(Copy &copy,void *source,void *destination,unsigned count);
        static void convert_direct32_direct24_rgba(Copy &copy,void *source,void *destination,unsigned count);
        static void convert_direct32_direct16_rgba(Copy &copy,void *source,void *destination,unsigned count);
        static void convert_direct32_direct8_rgba(Copy &copy,void *source,void *destination,unsigned count);
        static void convert_direct24_direct32_rgba(Copy &copy,void *source,void *destination,unsigned count);
        static void convert_direct24_direct24_rgba(Copy &copy,void *source,void *destination,unsigned count);
        static void convert_direct24_direct16_rgba(Copy &copy,void *source,void *destination,unsigned count);
        static void convert_direct24_direct8_rgba(Copy &copy,void *source,void *destination,unsigned count);
        static void convert_direct16_direct32_rgba(Copy &copy,void *source,void *destination,unsigned count);
        static void convert_direct16_direct24_rgba(Copy &copy,void *source,void *destination,unsigned count);
        static void convert_direct16_direct16_rgba(Copy &copy,void *source,void *destination,unsigned count);
        static void convert_direct16_direct8_rgba(Copy &copy,void *source,void *destination,unsigned count);
        static void convert_direct8_direct32_rgba(Copy &copy,void *source,void *destination,unsigned count);
        static void convert_direct8_direct24_rgba(Copy &copy,void *source,void *destination,unsigned count);
        static void convert_direct8_direct16_rgba(Copy &copy,void *source,void *destination,unsigned count);
        static void convert_direct8_direct8_rgba(Copy &copy,void *source,void *destination,unsigned count);

        // direct color to direct color conversion (rgb)

        // indexed color to direct color conversion
        static void convert_indexed8_direct32(Copy &copy,void *source,void *destination,unsigned count);
        static void convert_indexed8_direct24(Copy &copy,void *source,void *destination,unsigned count);
        static void convert_indexed8_direct16(Copy &copy,void *source,void *destination,unsigned count);
        static void convert_indexed8_direct8(Copy &copy,void *source,void *destination,unsigned count);

    private:

        // field data
        struct Field
        {
            int32 mask;
            int shift;
        };

        // format information
        struct Information
        {
            Field r;
            Field g;
            Field b;
            Field a;
        };

        // palette data        
        void *table;
        int32 buffer[256];
        
        // format data
        ptc::Core::Format s_format;
        ptc::Core::Format d_format;
        
        // conversion data
        int s_bytes;
        int d_bytes;
        Information info;
        Function convert;
        Function generate;
};




#endif
