//
// Console interface for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_BASE_CONSOLE_H
#define __PTC_BASE_CONSOLE_H

// include files
#include "Base/Surface.h"




namespace ptc
{
    namespace Base
    {
        class Console : public Surface
        {
            public:

                // virtual destructor
                virtual ~Console() {};

                // console management
                virtual void open(const char title[],int width,int height,const Format &format) = 0;
                virtual void close() = 0;

                // synchronization
                virtual void update() = 0;

                // pixel operations
                virtual void write(void *pixels,int width,int height,const Format &format,int32 palette[]) = 0;

                // keyboard input
                virtual bool key() = 0;
                virtual int read() = 0;

                // data access
                virtual const char* name() = 0;
        };
    }
}




#endif
