//
// Dos Keyboard class for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

// include files
#include "Core/Error.h"
#include "Dos/Keyboard.h"
#include <conio.h>



DosKeyboard::DosKeyboard()//HWND window,DWORD thread,bool multithreaded) : DosHook(window,thread)
{
    // defaults
    m_key = false;
    m_head = 0;
    m_tail = 0;

    // setup data
//    m_multithreaded = multithreaded;
}


DosKeyboard::~DosKeyboard()
{
    // destructor
}




bool DosKeyboard::key()
{
    // enter monitor if multithreaded
//    if (m_multithreaded) m_monitor.enter();

    // is a key ready?
    bool key = ready();

    // leave monitor if multithreaded
//    if (m_multithreaded) m_monitor.leave();

    // get key
    return key;
}


Key DosKeyboard::read()//DosWindow &window)
{
    // key data
    Key key;

        // update until ready
        while (!ready())
        {
            // update window
//            window.update();
        }

        // remove key
        key = remove();

    // return key data
    return key;
}







void DosKeyboard::insert(const Key &key)
{
    // check for overflow
    if (m_head!=m_tail-1)
    {
        // insert key at head
        m_buffer[m_head] = key;

        // increase head
        m_head ++;

        // wrap head from end to start
        if (m_head==sizeof(m_buffer)) m_head = 0;
    }
}


Key DosKeyboard::remove()
{
    // get key data from tail
    Key key = m_buffer[m_tail];

    // increase tail
    m_tail ++;

    // wrap tail from end to start
    if (m_tail==sizeof(m_buffer)) m_tail = 0;

    // return key
    return key;
}


bool DosKeyboard::ready()
{
    // check if key is ready

    if (kbhit())
    {
        int c=getch();
        Key key(c,false,false,false);
        insert(key);

    }

    return (m_head!=m_tail);
}
