//
// Stretching demo for PTC 2.0 C++ API
// Copyright (c) Robbin Bonthond (elemental@chaos.concepts.nl)
// This source code is licensed under the GNU GPL
//

#include <stdlib.h>

#include "mem.h"
#include "ptc.h"
#include "Image.h"

// random number
inline int random(int max)
{
  return rand() % max;
}

// random float
inline float nrandom()
{
  return rand() / (float)RAND_MAX;
}

void main()
{
  try {
    // create console
    Console console;
    Format format( 32, 0x00FF0000, 0x0000FF00, 0x000000FF );
    console.open( "Stretch example", 640, 480, format);

    // create surface matching console dimensions
    Surface surface( console.width(), console.height(), format );

    // load image to surface
    // (should be compatible with Titan, when it's released)
    Image *loader1 = new Image( "image.tga" );
    Image *loader2 = new Image( "bghigh1a.tga" );
    Surface image1( loader1->width(), loader1->height(), format );
    Surface image2( loader2->width(), loader2->height(), format );
    loader1->copy( image1 );
    loader2->copy( image2 );
    delete loader1, loader2;

    // get image dimensions
    Area src_area1( 0, 0, image1.width(), image1.height() );
    Area src_area2( 0, 0, image2.width(), image2.height() );

    // get surface dimensions
    int width  = surface.width();
    int height = surface.height();

    // loop until a key is pressed
    while( !console.key() ) {

      // stretch image area to surface area
      Area dst_area1( random(width), random(height), random(width), random(height) );
      Area dst_area2( random(width), random(height), random(width), random(height) );
      image1.copy( surface, src_area1, dst_area1 );
      image2.copy( surface, src_area2, dst_area2 );
            
      // copy to and update console
      surface.copy( console );
      console.update();
    }

    while( console.key() )
      console.read();

  }

  // report error
  catch( Error &error ) {
    error.report();
  }
}


