//
// Memory class for PTC 2.0 C++ API
// Copyright (c) Robbin Bonthond (elemental@chaos.concepts.nl)
// This source code is licensed under the GNU GPL
//

#include <stdio.h>
#include <malloc.h>
#include <stdlib.h>
#include "ptc.h"

// wierd... _msize is not completely accurate...
// sometimes 3 or 4 bytes to big

//
//  allocate a new block
//

static unsigned mem_cur=0, mem_max=0;

void * operator new( size_t size )
{
  void *ptr = malloc( size );
  if( ptr == NULL )
    throw Error( "out of memory" );

  mem_cur += _msize(ptr);
  return( ptr );
}

//
//  delete a block
//

void operator delete( void *ptr )
{
  if( mem_cur > mem_max )
    mem_max = mem_cur;
  mem_cur -= _msize(ptr);
  free( ptr );
}

//
//  return maximum ammount memory allocated
//

unsigned mem_used( void )
{
  return mem_max;
}

