//
// TGA image reader(8,16,24,32 bit picture) for PTC 2.0 C++ API
// Copyright (c) Robbin Bonthond (elemental@chaos.concepts.nl)
// This source code is licensed under the GNU GPL
//

#ifndef _Image_h
#define _Image_h

#include "mem.h"
#include "ptc.h"

class Image
{
  public:
    Image( char *filename );
    ~Image();
    tga( char *filename );

    void copy( Surface &surface );
    void copy( Surface &surface, const Area &src, const Area &dst );

    int width() const;
    int height() const;

    const Format& format() const;
    const Palette& palette() const;

    void* lock();
    void unlock();

  private:
    bool m_locked;
    int m_width;
    int m_height;
    void *m_pixels;
    Format m_format;
    Palette m_palette;
};


#endif

