//
// Console test for OpenPTC 1.0 C++ Implementation
// Copyright (c) Glenn Fiedler (ptc@gaffer.org)
// This source code is in the public domain
//

// include files
#include "ptc.h"
#include <stdio.h>
#include <string.h>


void main()
{
    try
    {
        // create console
        Console console;
        printf("created console\n");

        // check the console name
        if (strcmp(console.name(),"Porting Kit")==0)
        {
            // error message
            throw Error("the console name is still 'Porting Kit' change it in Console.cpp!");
        }
        else
        {
            // print console name information
            printf("the console name is \"%s\"\n",console.name());
        }

        // test console option
        if (console.option("this is a non-existant console option!@#@%$")==true)
        {
            // error message
            throw Error("you must return false when a console option is unrecognized");
        }
        else
        {
            // passed console option test
            printf("passed console option test\n");
        }

        // todo: when platform independent option strings are added to OpenPTC
        //       check that they are all recognized here!

        try
        {
            // test console open
            console.open("Console test");
            printf("passed default console open test\n");
        }
        catch (Error &error)
        {
            // error message
            throw Error("the default console open should never ever fail, so why did it just fail?!",error);
        }

        try
        {
            // open the console in direct color mode
            console.open("Console test",Format(32,0x00FF0000,0x0000FF00,0x000000FF));
            printf("opened console in direct color mode\n");

            // check console width
            if (console.width()<=0) throw Error("console width is less than or equal to zero after opening!");
            printf("passed console width test\n");

            // check console height
            if (console.height()<=0) throw Error("console height is less than or equal to zero after opening!");
            printf("passed console height test\n");

            // check console pitch
            if (console.pitch()<=0) throw Error("console pitch is less than or equal to zero after opening!");
            printf("passed console pitch test\n");

            // check console area
            if (console.area()!=Area(0,0,console.width(),console.height())) throw Error("console area is out of sync with console width and height");
            printf("passed console area test\n");

            // check console format
            if (console.format()==Format()) throw Error("console format is uninitialized after console open");
            printf("passed console format test\n");

            // check console title
            if (strcmp(console.title(),"Console test")) throw Error("console title does not match title when console was created!");

            try
            {
                // set the palette in direct color
                console.palette(Palette());
                printf("passed palette set in direct color test\n");
            }
            catch (Error &error)
            {
                // error message
                throw Error("setting the console palette must not throw an error in direct color mode",error);
            }

            // create a second console
            Console console_b;
            printf("created a second console\n");

            try
            {
                // open second console
                console_b.open("Console test (b)\n");
                printf("opened second console (correct behaviour for a windowed platform only!)\n");
            }                                                                 
            catch (Error &error)
            {
                // unable to open a second console
                printf("unable to open a second console (correct behaviour for a fullscreen platform only)\n");
                printf("cause of failure:\n");
                printf("%s\n",error.message());
            }
        }
        catch (Error &error)
        {
            // warning message
            printf("warning: unable to open a direct color console\n");
            printf("cause of failure:\n");
            printf("%s\n\n",error.message());
        }

        // get the console information
        const char *information = console.information();
        if (information[0]==0) printf("warning: console information returns an empty string!\n");
        else
        {
            // print console information
            printf("\n\n[console information]\n%s\n\n",information);
        }

        // get console modes
        const Mode *modes = console.modes();
       
        // mode index
        int index = 0;

        // iterate through all modes
        while (modes[index].valid())
        {
            try
            {
                // open console with mode from mode list
                console.open("Console test",modes[index]);
            }
            catch (Error &error)
            {
                // this should not happen under normal circumstances!
                throw Error("you reported a mode was available in the mode list but when i tried to set it an exception was thrown!",error);
            }
        }

        // check index
        if (index==0)
        {
            // no modes are in the list
            printf("warning: the modes list is empty. this is acceptable for windowed platforms and platforms where a mode list is not provided. otherwise you should provide a mode list!");
        }

        // finished the console test
        printf("\n\ncongratulations you passed the console test!\n\n\n");
    }
    catch (Error &error)
    {
        // report error
        error.report();
    }
}
