#include <fstream.h>
#include <iostream.h>
#include <math.h>
#include <stdlib.h>
#include "ptc.h"



void load(Surface &surface,char filename[])
{
    // open image file
    ifstream is(filename,ios::binary|ios::in);

    // skip header
    is.seekg(18);

    // get surface dimensions
    int width  = surface.width();
    int height = surface.height();
    
    // allocate image pixels
    char8 *pixels = new char8[width*height*3];

    // read image pixels one line at a time
    for (int y=height-1; y>=0; y--) is.read((char*)&pixels[width*y*3],width*3);

    // load pixels to surface
    surface.load(pixels,width,height,width*3,Format(24,0x00FF0000,0x0000FF00,
					    0x000000FF),Palette());

    // free image pixels
    delete[] pixels;
}



int main()
{

  try {
    Format format(16,0xF800,0x7E0,0x1F);

    Surface surface(320,200,Format(32,0x00FF0000,0x0000FF00,0x000000FF));

    load(surface,"Image.tga");

    Console console;
    console.open("Stretch test",640,480,format);


    float parameter=0.0;
    float parameter_pos=0.0;
    
    while (!console.key()) {
    
      float width,height,x,y;

      x=sin(parameter_pos)*240+160;
      y=150-fabs(cos(parameter_pos*3))*150;

      width=sin(parameter)*500+250;
      height=cos(parameter+1.2)*200+100;

      Area area((int)x,(int)y,(int)(x+width),(int)(y+width));

      console.clear(Color(0,0,0));

      surface.copy(console,Area(0,0,320,200),area);
      
      console.update();

      parameter+=0.1;
      parameter_pos+=0.05;
    }

    return 0;
  }
  catch (Error &e) {
    e.report();
  }
}
