//
// Tunnel3D demo for OpenPTC 1.0 C++ API
//
// Realtime raytraced tunnel
// Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
// This source code is licensed under the GNU LGPL
//
// And do not just blatantly cut&paste this into your demo :)
//

#ifndef __TUNNEL_H__
#define __TUNNEL_H__

#include "ptc.h"
#include "Calc.h"

class RayTunnel {
  char8 *tunneltex;                      // Texture
  char8 *pal;                            // Original palette
  int32 *lookup;                         // Lookup table for lighting

  float *sintab,*costab;                 // Take a guess
  int *atantab;

  int *u_array,*v_array,*l_array;        // Raytraced coordinates and light
  Vector *norms;
  
  float radius,radius_sqr;
  Matrix rot;

  Vector pos,light;                      // Position in the tunnel, pos of
  int xa,ya,za;                          // lightsource, angles

  char lightstatus;                      // Following the viewer ?
  
public:
  RayTunnel(float rad);                  // Constructor takes the radius
  ~RayTunnel();

  void load_texture();

  void tilt(int,int,int);                 // Rotate relative
  void tilt(int,int,int,char abs);        // Absolute

  void move(float,float,float);           // Relative move
  void move(float,float,float,char abs);  // Absolute

  void movelight(float,float,float);
  void movelight(float,float,float,char abs);

  void locklight(char lock);              // Make the light follow the viewer

  void interpolate();                     // Raytracing

  void draw(int32 *dest);                 // Draw the finished tunnel
};

#endif
