;
; x86 assembler lookup generators for PTC 2.0 C++ API
; Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
; The PTC 2.0 C++ API is (c) 1998 Glenn Fiedler (ptc@gaffer.org)
; This source code is licensed under the GNU LGPL
; 
; Please refer to the file COPYING.LIB contained in the distribution for
; licensing conditions		
;
	
BITS 32

GLOBAL AsmGenLookup_32RGB888
GLOBAL AsmGenLookup_16RGB565
GLOBAL x86lookup
	
SECTION .data

x86lookup dd 0
	
SECTION .text align=16

;; Input (from compiler):	
;; [esp+8] palette addres
;; [esp+12] lookup address

 
AsmGenLookup_32RGB888:
	push ebp
	mov ebp,esp

	mov ecx,256

	mov esi,[ebp+8]
	mov edi,[ebp+12]

	mov [x86lookup],edi

	rep movsd		; Ok, this one isn't too hard :))	

	pop ebp
	ret

	
	
AsmGenLookup_16RGB565:
	push ebp
	mov ebp,esp
	
	mov ecx,256

	mov esi,[ebp+8]
	mov edi,[ebp+12]

	mov [x86lookup],edi
	
.L1:
	mov eax,[esi]
	add esi,4
	
	mov ebx,eax		; ebx = green, edx = red
	mov edx,eax

	shr al,3
	and ebx,0fc00h

	shr edx,8
	and eax,01fh

	shr ebx,5
	and edx,0f800h

	or eax,ebx
	or eax,edx

	mov [edi],eax
	add edi,4
		
	dec ecx
	jnz .L1

	pop ebp
		
	ret

	
