;
; x86 format converters for PTC 2.0 C++ API
; Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
; The PTC 2.0 C++ API is (c) 1998 Glenn Fiedler (ptc@gaffer.org)
; This source code is licensed under the GNU LGPL
; 
; Please refer to the file COPYING.LIB contained in the distribution for
; licensing conditions		
; 

BITS 32

GLOBAL ConvertI8_32
GLOBAL ConvertI8_16
GLOBAL ConvertI8_INDEX8

EXTERN ConvertX86
EXTERN x86return
EXTERN x86lookup
	
SECTION .text align=16


;; Convert_*
;; Paramters:	
;;   ESI = source 
;;   EDI = dest
;;   ECX = amount (NOT 0!!! (the ConvertX86 routine checks for that though))
;; Destroys:
;;   EAX, EBX, EDX

ConvertI8_32:	

	mov ebx,0
	mov edx,[x86lookup]
.L1:
	mov bl,[esi]
	inc esi
	
	mov eax,[edx+ebx*4]

	mov [edi],eax
	add edi,4

	dec ecx
	jnz .L1

	jmp x86return
	
		
ConvertI8_16:
	mov ebx,0
	mov edx,[x86lookup]

	push ecx

	test ecx,1		; Odd line length ?
	jz .L1			; No

	dec ecx			
	jz .L2			; Line = 1 pixel ?
	
.L1:
	mov bl,[esi]		; This loop sucks, it's full of delays
	                        ; I'll optimise it when I have time 
	mov eax,[edx+ebx*4]

	mov bl,[esi+1]
	add esi,2
	
	shl eax,16
	
	or eax,[edx+ebx*4]
	
	mov [edi],eax
		
	add edi,4

	dec ecx
	dec ecx
	jnz .L1

.L2:
	pop ecx

	test ecx,1
	jz .L3

	mov eax,0		; draw the remaining pixel, no need to be
	mov al,[esi]		; superfast
	mov ebx,[edx+eax*4]
	mov [edi],bx		; better than two byte moves, according to
	                        ; intel's docs
	 
	inc esi
	add edi,2
	
.L3:		
	jmp x86return
		

ConvertI8_INDEX8:
	mov edx,ecx

	test ecx,3		; Width is a multiple of 4
	jz .L1

	and ecx,0fffffffch	; Clear the lower two bits = number of
	                        ; blocks of 4 pixels we can draw
	jz .L2			; We have 1,2 or 3 pixels only!
	
.L1:
	mov eax,[esi]
	add esi,4

	mov [edi],eax
	add edi,4

	sub ecx,4
	jnz .L1

.L2:
	mov ecx,edx		; Get the remaining pixels to draw
	and ecx,3
	
	jz .L4			; width was modulo 4
	
.L3:	
	mov al,[esi]
	inc esi
	
	mov [edi],al
	inc edi
		
	dec ecx
	jnz .L3
	
.L4:	
	jmp x86return


