;
; x86 format converters for PTC 2.0 C++ API
; Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
; The PTC 2.0 C++ API is (c) 1998 Glenn Fiedler (ptc@gaffer.org)
; This source code is licensed under the GNU LGPL
; 
; Please refer to the file COPYING.LIB contained in the distribution for
; licensing conditions		
; 

	
BITS 32

GLOBAL Convert32_16RGB565
GLOBAL Convert32_32RGB888
GLOBAL Convert32_8RGB332

GLOBAL ConvertX86
GLOBAL x86return
	
SECTION .text align=16


;; Convert_*
;; Paramters:	
;;   ESI = source 
;;   EDI = dest
;;   ECX = amount (NOT 0!!! (the ConvertX86 routine checks for that though))
;; Destroys:
;;   EAX, EBX, EDX


Convert32_32RGB888:
	;; I'll use the fpu later.. for now, this is enough
.L1:
	mov eax,[esi]		
	add esi,4
	
	mov [edi],eax
	add edi,4

	dec ecx
	jnz .L1

	jmp x86return


;; From:	00000000 | rrrrrrrr | gggggggg | bbbbbbbb
;;   To:	00000000 | 00000000 | rrrrrggg | gggbbbbb
;; Algorithm:
;;   - Look if there's just one pixel
;;   - If not, draw ecx/2 pixel pairs
;;   - Draw a singled odd pixels that may be left the slow way
	
Convert32_16RGB565:

	push ecx
	
	test ecx,1
	jz .L1

	dec ecx
	jz .L2			; There was just one pixel to draw.. er..
	
.L1:
	mov eax,[esi]
	
	mov edx,eax
	mov ebx,eax
	
	shr edx,5
	and eax,0000000011111000b
	
	shr al,3
	and edx,0000011111100000b

	shr ebx,8
	or eax,edx

	and ebx,1111100000000000b
	mov edx,[esi+4]
	
	or eax,ebx
	add esi,8
	
	shl eax,16
	mov ebx,edx
	
	shr dl,3
	and dl,0000000000011111b
	
	shr ebx,5
	and ebx,0000011111100000b
	
	mov al,dl
	or eax,ebx
	
	shr edx,8
	and edx,1111100000000000b
	
	or eax,edx
	
	ror eax,16
	
	mov [edi],eax
	add edi,4
	
	dec ecx
	dec ecx
	
	jnz .L1


.L2:
	pop ecx
	and ecx,1
	jz .L3
			
	mov ebx,[esi]

	mov eax,ebx
	mov edx,ebx
	
	shr eax,3
	shr edx,5
	
	and eax,0000000000011111b
	and edx,0000011111100000b

	shr ebx,8

	or eax,edx

	and ebx,1111100000000000b

	or eax,ebx

	mov [edi],al
	mov [edi+1],ah

	add edi,2
	add esi,4
	
.L3:	
	jmp x86return

	

Convert32_8RGB332:

	push ecx

	test ecx,3		; line width mod 4 = 0 ?
	jz .L1

	and ecx,0fffffffch	; line width = 1,2 or 3
	jnz .L1
	
	jmp .L2			; short jump out of range :(
	
.L1:
	mov eax,[esi]		; first pair of pixels
	mov edx,[esi+4]

	shr dl,6
	mov ebx,eax

	shr al,6
	and ah,0e0h

	shr ebx,16
	and dh,0e0h
	
	shr ah,3
	and bl,0e0h

	shr dh,3
	
	or al,bl
	
	mov ebx,edx	
	or al,ah
	
	shr ebx,16
	or dl,dh

	and bl,0e0h
	
	or dl,bl

	mov ah,dl

	
		
	mov ebx,[esi+8]		; second pair of pixels

	mov edx,ebx
	and bh,0e0h

	shr bl,6
	and edx,0e00000h

	shr edx,16

	shr bh,3

	ror eax,16
	or bl,dl

	mov edx,[esi+12]
	or bl,bh
	
	mov al,bl

	mov ebx,edx
	and dh,0e0h

	shr dl,6
	and ebx,0e00000h
	
	shr dh,3
	mov ah,dl

	shr ebx,16
	or ah,dh

	or ah,bl

	rol eax,16
	add esi,16
			
	mov [edi],eax	
	add edi,4
	

	sub ecx,4
	jz .L2			; L1 out of range for short jump :(
	
	jmp .L1
.L2:
	
	pop ecx
	and ecx,3		; mask out number of pixels to draw
	
	jz .L4			; Nothing to do anymore

.L3:
	mov eax,[esi]		; single pixel conversion for trailing pixels

        mov ebx,eax

        shr al,6
        and ah,0e0h

        shr ebx,16

        shr ah,3
        and bl,0e0h

        or al,ah
        or al,bl

        mov [edi],al

        inc edi
        add esi,4

	dec ecx
	jnz .L3
	
.L4:	
	jmp x86return



;; ConvertX86:	 
;; EAX = ConverterInfo*
;; --------------------------------------------------------------------------
;; ConverterInfo (ebp+..)
;;   0:	void *s_pixels
;;   4:	int s_width
;;   8:	int s_height
;;  12:	int s_add
;;  16:	void *d_pixels
;;  20:	int d_width
;;  24:	int d_height
;;  28:	int d_add
;;  32:	void (*converter_function)() 
ConvertX86:

	cmp dword [eax+4],0
	je endconvert
	
	push ebp
	mov ebp,eax
	
	mov esi,[ebp+0]
	mov edi,[ebp+16]
	
y_loop:	
	mov ecx,[ebp+4]

	jmp [ebp+32]

x86return:	
	add esi,[ebp+12]
	add edi,[ebp+28]
	
	dec dword  [ebp+24]
	jnz y_loop

	
	pop ebp

endconvert:	
	ret		