;
; MMX format converters for PTC 2.0 C++ API
; Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
; The PTC 2.0 C++ API is (c) 1998 Glenn Fiedler (ptc@gaffer.org)
; This source code is licensed under the GNU LGPL
; 
; Please refer to the file COPYING.LIB contained in the distribution for
; licensing conditions		
; 
; The MMX detection routine partly contains code that is (c)1994 Intel
; Corporation.
;
	
BITS 32

GLOBAL ConvertMMX
GLOBAL checkMMX
	
GLOBAL ConvertMMX32_32RGB888
GLOBAL ConvertMMX32_16RGB565

	
SECTION .data

ALIGN 16	
mmx32_rgb565_rb dd 00f800f8h,00f800f8h
mmx32_rgb565_add dd 20000004h,20000004h
mmx32_rgb565_g dd 0000fc00h,0000fc00h
cpu_flags dd 0
		
SECTION .text


ConvertMMX32_32RGB888:

	mov edx,ecx
	
	test ecx,1		; Check for odd line length
	jz .L1			; nope
	
	dec ecx
	jz .L2			; Length = 1 pixel
			
.L1:
	movq mm0,[esi]
	add esi,8

	movq [edi],mm0
	add edi,8

	sub ecx,2
	jnz .L1

.L2:
	mov ecx,edx
	
	test ecx,1
	jz .L3

	mov eax,[esi]
	mov [edi],eax

	add esi,4
	add edi,4
	
.L3:			
	jmp mmxreturn


	
ConvertMMX32_16RGB565:
	movq mm6,qword [mmx32_rgb565_g]
	movq mm7,qword [mmx32_rgb565_add]

	mov edx,ecx		; save length for later

	test ecx,1
	jz .L1

	dec ecx
	jz .L2
	
.L1:	
	movq mm0,[esi]
	add esi,8

	movq mm1,mm0
	pand mm0,qword [mmx32_rgb565_rb]

	pmaddwd mm0,mm7
	pand mm1,mm6

	por mm0,mm1
	psrlq mm0,5

	punpckhwd mm0,mm0

	movd [edi],mm0
	add edi,4
	
	sub ecx,2
	jz .L2
	
	jmp .L1

.L2:
	mov ecx,edx		; Restore length
	
	test ecx,1
	jz .L3

	mov ebx,[esi]		; Convert one remaining pixel, no need to
	                        ; be super fast 
        mov eax,ebx
        mov edx,ebx

        shr eax,3
        shr edx,5

        and eax,0000000000011111b
        and edx,0000011111100000b

        shr ebx,8

        or eax,edx

        and ebx,1111100000000000b

        or eax,ebx

        mov [edi],al
        mov [edi+1],ah
	
	add esi,4
	add edi,2	
	
.L3:			
	jmp mmxreturn

	
;; ConvertMMX:	 
;; EAX = ConverterInfo*
;; --------------------------------------------------------------------------
;; ConverterInfo (ebp+..)
;;   0:	void *s_pixels
;;   4:	int s_width
;;   8:	int s_height
;;  12:	int s_add
;;  16:	void *d_pixels
;;  20:	int d_width
;;  24:	int d_height
;;  28:	int d_add
;;  32:	void (*converter_function)() 
ConvertMMX:

	cmp dword [eax+4],0
	je endconvert
	
	push ebp
	mov ebp,eax
	
	mov esi,[ebp+0]
	mov edi,[ebp+16]

	
y_loop:	
	mov ecx,[ebp+4]

	jmp [ebp+32]

mmxreturn:	
	add esi,[ebp+12]
	add edi,[ebp+28]
	
	dec dword  [ebp+24]
	jnz y_loop

	
	pop ebp

endconvert:
	emms
	ret		


	
checkMMX:
	pushfd
	pop eax
	
	mov ecx,eax
	
	xor eax,040000h
	push eax
	
	popfd
	pushfd

	pop eax
	xor eax,ecx
	jz .L1			; Processor is 386

	push ecx
	popfd

	mov eax,ecx
	xor eax,200000h

	push eax
	popfd
	pushfd

	pop eax
	xor eax,ecx
	je .L1
	
	pusha
	
	mov eax,1
	cpuid

	mov [cpu_flags],edx

	popa

	mov eax,[cpu_flags]

.L1:	
	ret
	

