//
// Copy class for PTC 2.0 C++ API
// Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
// The PTC 2.0 C++ API is (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//
// Please refer to the file COPYING.LIB contained in the distribution for
// licensing conditions
//

#include <iostream.h>
#include <list.h>
#include "ptconfig.h"
#include "Error.h"

#include "Converter_C.h"
#include "Converter_x86.h"
#include "Converter_mmx.h"

#include "Copy.h"

Copy::Copy()
{ m_numconverters=3;

  m_converters=new (BaseConverter *)[m_numconverters];

  m_converters[0]=new Converter_MMX;
  m_converters[1]=new Converter_x86;
  m_converters[2]=new Converter_C;
}

Copy::~Copy()
{
  for(int i=0;i<m_numconverters;i++)
  delete m_converters[i];

  delete [] m_converters;
  
}


void Copy::request(const Format &source,const Format &destination,
  const bool stretch)
{ 
  for(int i=0;i<m_numconverters;i++)
  { if(m_converters[i]->request(source,destination,stretch))
    { m_active=m_converters[i];
      return;
    }
  }

  throw Error("Requested format conversion not available");
}


void Copy::palette(const int32 palette[])
{
  m_active->palette(palette);
}


void Copy::copy(const void *s_pixels,int s_x,int s_y,int s_width,int s_height,
  int s_pitch,void *d_pixels,int d_x,int d_y,int d_width,int d_height,
  int d_pitch)
{ 
  m_active->copy(s_pixels,s_x,s_y,s_width,s_height,s_pitch,
		 d_pixels,d_x,d_y,d_width,d_height,d_pitch);
}




