//
// C interface for x86 assembler converters for PTC 2.0 C++ API
// Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
// The PTC 2.0 C++ API is (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//
// Please refer to the file COPYING.LIB contained in the distribution for
// licensing conditions
//

#include "Converter_x86.h"
#include <iostream.h>

#ifndef NO_ASSEMBLER

Converter_x86::Converter_x86()
{ m_source=Format();
  m_dest=Format();

  m_lookup=new char[256*4];
}


Converter_x86::~Converter_x86()
{ if(m_lookup)
  delete [] m_lookup;
}


bool Converter_x86::request(const Format &source,const Format &destination,
  const bool stretch)
{ // We have already selected an x86 converter once
  if(source==m_source && destination==m_dest && stretch==m_stretch) 
  return true;
  
  if(stretch) return false;

  m_converter=0;


  // Looks horrible, but it only gets set up once per program normally

  switch(source.bits())
  { case 32: switch(destination.bits()) 
             { case 8:  if(destination.direct() && destination.r()==0xe0 &&
			   destination.g()==0x1c && destination.b()==0x3)
	                { m_converter=Convert32_8RGB332;
			  break;
			}
			break;

	       case 16: m_converter=Convert32_16RGB565;
	                break;

	       case 32: m_converter=Convert32_32RGB888;
		        break;
	     }
	     break;

     case 8: if(source.indexed())
             switch(destination.bits())
	     {  case 8: m_converter=ConvertI8_INDEX8;
	                break;

	       case 16: m_converter=ConvertI8_16;
			break;

	       case 32: m_converter=ConvertI8_32;
			break;
	     }
             break;
  }

  if(m_converter)
  { m_source=source;
    m_dest=destination;
    m_stretch=stretch;

    cerr << "x86 asm conversion!" << endl << flush;

    return true;
  }

  return false;
}


void Converter_x86::palette(const int32 palette[])
{ 
  if(m_source.bits()==8 && m_source.indexed())
  switch(m_dest.bits())
  { case 16: AsmGenLookup_16RGB565(palette,m_lookup);
             break;
    case 32: AsmGenLookup_32RGB888(palette,m_lookup);
             break;
  }
}


void Converter_x86::copy(const void *s_pixels,int s_x,int s_y,int s_width,
  int s_height,int s_pitch,void *d_pixels,int d_x,int d_y,int d_width,
  int d_height,int d_pitch)
{ ConverterInfoAsm cinfo;

  cinfo.s_pixels=(char *)s_pixels;
  cinfo.s_width=s_width; cinfo.s_height=s_height;
  cinfo.s_add=s_pitch-s_width*m_source.bits()/8;

  cinfo.d_pixels=(char *)d_pixels;
  cinfo.d_width=d_width; cinfo.d_height=d_height;
  cinfo.d_add=d_pitch-d_width*m_dest.bits()/8;

  cinfo.s_pixels+=s_y*s_pitch+s_x*m_source.bits()/8;
  cinfo.d_pixels+=d_y*d_pitch+d_x*m_dest.bits()/8;

  cinfo.conv_func=m_converter;

  ConvertX86(&cinfo);
}

#endif
