//
// C interface for the MMX converters for PTC 2.0 C++ API
// Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
// The PTC 2.0 C++ API is (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//
// Please refer to the file COPYING.LIB contained in the distribution for
// licensing conditions
//

#ifndef PTC_BASE_CONVERTER_MMX_H__
#define PTC_BASE_CONVERTER_MMX_H__

#include "BaseConverter.h"




#ifndef NO_ASSEMBLER

extern "C" void ConvertMMX(ConverterInfoAsm *) __attribute__ ((regparm(1)));
extern "C" int checkMMX();

class Converter_MMX : public BaseConverter {
public:
  Converter_MMX();

  // Conversion from source to destination available ?
  virtual bool request(const Format &source,const Format &destination,
		       const bool stretch);

  // Set palette
  virtual void palette(const int32 palette[]);

  virtual void copy(const void *s_pixels,int s_x,int s_y,int s_width,
		    int s_height,int s_pitch,void *d_pixels,int d_x,int d_y,
		    int d_width,int d_height,int d_pitch);

private:
  Format m_source,m_dest;

  // Converter function to pass to ConvertX86
  void (*m_converter)(void);

  // MMX CPU present ?
  bool m_available;
};

extern "C" void ConvertMMX32_32RGB888();
extern "C" void ConvertMMX32_16RGB565();




#else



class Converter_MMX : public BaseConverter {
public:
  Converter_MMX() {}

  // Conversion from source to destination available ?
  virtual bool request(const Format &source,const Format &destination,
		       const bool stretch)
  { return false; }

  // Set palette
  virtual void palette(const int32 palette[]) {}

  virtual void copy(const void *s_pixels,int s_x,int s_y,int s_width,
		    int s_height,int s_pitch,void *d_pixels,int d_x,int d_y,
		      int d_width,int d_height,int d_pitch) {}
};

#endif // NO_ASSEMBLER

#endif





