//
// C interface for the MMX converters for PTC 2.0 C++ API
// Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
// The PTC 2.0 C++ API is (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//
// Please refer to the file COPYING.LIB contained in the distribution for
// licensing conditions
//

#include "Converter_mmx.h"
#include <iostream.h>

#ifndef NO_ASSEMBLER

Converter_MMX::Converter_MMX()
{ m_available=false;
  
  m_source=Format();
  m_dest=Format();

  int res=checkMMX();
  if(res&0x800000) m_available=true;

  cerr << "CPUID flags: " << hex << res << endl << flush;
}

bool Converter_MMX::request(const Format &source,const Format &destination,
  const bool stretch)
{ 
  // No MMX processor
  if(!m_available) return false;


  if(source==m_source && destination==m_dest && stretch==m_stretch) return true;
  if(stretch) return false;
 
  m_converter=0;

  switch(source.bits())
  { case 32: switch(destination.bits()) 
             { case 16: m_converter=ConvertMMX32_16RGB565;
	                break;
	       
	       case 32: m_converter=ConvertMMX32_32RGB888;
			break;
	     }
	     break;
  }

  if(m_converter)
  { m_source=source;
    m_dest=destination;
    m_stretch=stretch;
    
    cerr << "mmx conversion!" << flush;
    
    return true;
  }

  return false;
}


void Converter_MMX::palette(const int32 palette[])
{

}


void Converter_MMX::copy(const void *s_pixels,int s_x,int s_y,int s_width,
  int s_height,int s_pitch,void *d_pixels,int d_x,int d_y,int d_width,
  int d_height,int d_pitch)
{ ConverterInfoAsm cinfo;

  cinfo.s_pixels=(char *)s_pixels;
  cinfo.s_width=s_width; cinfo.s_height=s_height;
  cinfo.s_add=s_pitch-s_width*m_source.bits()/8;

  cinfo.d_pixels=(char *)d_pixels;
  cinfo.d_width=d_width; cinfo.d_height=d_height;
  cinfo.d_add=d_pitch-d_width*m_dest.bits()/8;

  cinfo.s_pixels+=s_y*s_pitch+s_x*m_source.bits()/8;
  cinfo.d_pixels+=d_y*d_pitch+d_x*m_dest.bits()/8;

  cinfo.conv_func=m_converter;

  ConvertMMX(&cinfo);
}

#endif
