//
// Base class for converters for the PTC 2.0 C++ API
// Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
// The PTC 2.0 C++ API is (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//
// Please refer to the file COPYING.LIB contained in the distribution for
// licensing conditions
//

#ifndef PTC_BASE_CONVERTER_H__
#define PTC_BASE_CONVERTER_H__

#include "../ptconfig.h"
#include "../Format.h"

#ifndef NO_ASSEMBLER

struct ConverterInfoAsm {
  char *s_pixels;
  int s_width,s_height;
  int s_add;

  char *d_pixels;
  int d_width,d_height;
  int d_add;

  void (*conv_func)(void);
};

// Assembler routine to create a lookup table from palette[] into *lookup
// Note that lookup has to be allocated before calling this!
extern "C" void AsmGenLookup_32RGB888(const int32 palette[],void *lookup);
extern "C" void AsmGenLookup_16RGB565(const int32 palette[],void *lookup);

#endif

class BaseConverter {

public:

  // Conversion from source to destination available ?
  virtual bool request(const Format &source,const Format &destination,
		       const bool stretch) = 0;

  // Set palette
  virtual void palette(const int32 palette[]) = 0;

  virtual void copy(const void *s_pixels,int s_x,int s_y,int s_width,
		    int s_height,int s_pitch,void *d_pixels,int d_x,int d_y,
		    int d_width,int d_height,int d_pitch) = 0;

protected:
  bool m_stretch;
};

#endif


