//
// RNI Console class for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// package name
package ptc.rni;

// import classes
import ptc.Key;
import ptc.Area;
import ptc.Mode;
import ptc.Error;
import ptc.Color;
import ptc.Format;
import ptc.Palette;



public class Console implements ptc.base.Console
{
    public Console() throws Error
    {
        // register console
        Error.register(this);

        // create
        create();
    }

    protected void finalize() throws Error
    {
        // unregister console
        Error.unregister(this);

        // close
        close();
        
        // destroy
        destroy();
    }

    //
    // Work around lack of overloaded member function support in msjavah!!
    // -------------------------------------------------------------------
    // 

    // native methods
    private native void create() throws Error;
    private native void destroy() throws Error;
    public native void configure(String file) throws Error;
    public native boolean option(String option) throws Error;
    public native Mode[] modes() throws Error;
    public native void open_1(String title) throws Error;
    public native void open_2(String title,int pages) throws Error;
    public native void open_3(String title,Format format) throws Error;
    public native void open_4(String title,Format format,int pages) throws Error;
    public native void open_5(String title,int width,int height,Format format) throws Error;
    public native void open_6(String title,int width,int height,Format format,int pages) throws Error;
    public native void open_7(String title,Mode mode) throws Error;
    public native void open_8(String title,Mode mode,int pages) throws Error;
    public native void close() throws Error;
    public native void flush() throws Error;
    public native void finish() throws Error;
    public native void update_1() throws Error;
    public native void update_2(Area area) throws Error;
    public native boolean key() throws Error;
    public native Key read() throws Error;
    public native void copy_1(ptc.base.Surface surface) throws Error;
    public native void copy_2(ptc.base.Surface surface,Area source,Area destination) throws Error;
    public native Object lock() throws Error;
    public native void unlock() throws Error;
    public native void load_1(Object pixels,int width,int height,int pitch,Format format,Palette palette) throws Error;
    public native void load_2(Object pixels,int width,int height,int pitch,Format format,Palette palette,Area source,Area destination) throws Error;
    public native void save_1(Object pixels,int width,int height,int pitch,Format format,Palette palette) throws Error;
    public native void save_2(Object pixels,int width,int height,int pitch,Format format,Palette palette,Area source,Area destination) throws Error;
    public native void clear_1() throws Error;
    public native void clear_2(Color color) throws Error;
    public native void clear_3(Color color,Area area) throws Error;
    public native void palette_1(Palette palette) throws Error;
    public native Palette palette_2() throws Error;
    public native void clip(Area area) throws Error;
    public native int width() throws Error;
    public native int height() throws Error;
    public native int pages() throws Error;
    public native int pitch() throws Error;
    public native Area area() throws Error;
    public native Area clip() throws Error;
    public native Format format() throws Error;
    public native String name() throws Error;
    public native String title() throws Error;
    public native String information() throws Error;

    //
    // Work around lack of overloaded member function support in msjavah!!
    // -------------------------------------------------------------------
    
    public void open(String title) throws Error
    {
        open_1(title);
    }

    public void open(String title,int pages) throws Error
    {
        open_2(title,pages);
    }

    public void open(String title,Format format) throws Error
    {
        open_3(title,format);
    }

    public void open(String title,Format format,int pages) throws Error
    {
        open_4(title,format,pages);
    }

    public void open(String title,int width,int height,Format format) throws Error
    {
        open_5(title,width,height,format);
    }

    public void open(String title,int width,int height,Format format,int pages) throws Error
    {
        open_6(title,width,height,format,pages);
    }

    public void open(String title,Mode mode) throws Error
    {
        open_7(title,mode);
    }

    public void open(String title,Mode mode,int pages) throws Error
    {
        open_8(title,mode,pages);
    }

    public void update() throws Error
    {
        update_1();
    }

    public void update(Area area) throws Error
    {
        update_2(area);
    }

    public void copy(ptc.base.Surface surface) throws Error
    {
        copy_1(surface);
    }

    public void copy(ptc.base.Surface surface,Area source,Area destination) throws Error
    {
        copy_2(surface,source,destination);
    }

    public void load(Object pixels,int width,int height,int pitch,Format format,Palette palette) throws Error
    {
        load_1(pixels,width,height,pitch,format,palette);
    }

    public void load(Object pixels,int width,int height,int pitch,Format format,Palette palette,Area source,Area destination) throws Error
    {
        load_2(pixels,width,height,pitch,format,palette,source,destination);
    }

    public void save(Object pixels,int width,int height,int pitch,Format format,Palette palette) throws Error
    {
        save_1(pixels,width,height,pitch,format,palette);
    }

    public void save(Object pixels,int width,int height,int pitch,Format format,Palette palette,Area source,Area destination) throws Error
    {
        save_2(pixels,width,height,pitch,format,palette,source,destination);
    }

    public void clear() throws Error
    {
        clear_1();
    }

    public void clear(Color color) throws Error
    {
        clear_2(color);
    }

    public void clear(Color color,Area area) throws Error
    {
        clear_3(color,area);
    }

    public void palette(Palette palette) throws Error
    {
        palette_1(palette);
    }

    public Palette palette() throws Error
    {
        return palette_2();
    }
}
