//
// Timer interface for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// package name
package ptc.base;

// class imports
import ptc.Error;



public interface Timer
{
    // set time
    public void set(double time) throws Error;

    // control
    public void start() throws Error;
    public void stop() throws Error;
    
    // time data
    public double time() throws Error;
    public double delta() throws Error;
    public double resolution() throws Error;
}
