//
// Clear class for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// package
package ptc;



public class Clear implements ptc.base.Clear
{
    public Clear() throws Error
    {
        // initialize factory
        Factory.initialize();

        // create clear object
        clear = Factory.clear();
    }
    
    protected void finalize() throws Error
    {
        // free factory
        Factory.free();

        // null clear
        clear = null;
    }

    public void request(Format format) throws Error
    {
        // set clear format
        clear.request(format);
    }
    
    public void clear(Object pixels,int x,int y,int width,int height,int pitch,Color color) throws Error
    {
        // clear pixels
        clear.clear(pixels,x,y,width,height,pitch,color);
    }

    // internal clear object
    private ptc.base.Clear clear;
}
