//
// Window class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include <memory.h>
#include "Core/Error.h"
#include "Win32/Window.h"

// asm'98 hack!
#include "DirectX/Display.h"
using ptc::DirectX::Display;

// using directive
using namespace ptc::Win32;

// using declarations
using ptc::Core::Error;




Window::Window(HWND window)
{
    // defaults
    defaults();

    // setup window
    m_window = window;
}


Window::Window(const char title[],unsigned extra,unsigned style,int show,int x,int y,int width,int height,void *data)
{
    // defaults
    defaults();

    try
    {
        // get module instance
        HINSTANCE instance = GetModuleHandle("ptc.dll");
        if (!instance) instance = GetModuleHandle(0);

		// get cursor dimensions
		int cursor_width = GetSystemMetrics(SM_CXCURSOR);
		int cursor_height = GetSystemMetrics(SM_CYCURSOR);

		// setup cursor bits
        char8 and_map[256];
		memset(and_map,0xFF,256);
        char8 xor_map[256];
		memset(xor_map,0x00,256);
        
        // create null cursor
        m_cursor = CreateCursor(0,0,0,cursor_width,cursor_height,and_map,xor_map);
		if (!m_cursor) throw Error("could not create cursor");

        // register window class
        WNDCLASSEX wc;
        wc.cbSize        = sizeof(WNDCLASSEX);
        wc.hInstance     = GetModuleHandle(0);
        wc.lpszClassName = "PTC_WINDOW";
        wc.lpfnWndProc   = (WNDPROC)WndProc;
        wc.style         = CS_VREDRAW|CS_HREDRAW;
        wc.hIcon         = LoadIcon(instance,"IDI_PTC_ICON");
        wc.hIconSm       = 0;
        wc.hCursor       = m_cursor;
        wc.lpszMenuName  = 0;
        wc.cbClsExtra    = 0;
        wc.cbWndExtra    = 0;
        wc.hbrBackground = 0;//GetStockObject(BLACK_BRUSH);
        RegisterClassEx(&wc);

        // setup window data
        strcpy(this->name,"PTC_WINDOW");
        strcpy(this->title,title);
        this->extra  = extra;
        this->style  = style;
        this->show   = show;
        this->x      = x;
        this->y      = y;
        this->width  = width;
        this->height = height;
        this->data   = data;

        // create window event
        m_event = CreateEvent(0,0,0,0);

        // create window thread
        m_thread = CreateThread(0,0,(LPTHREAD_START_ROUTINE)ThreadFunction,this,0,&m_id);

        // wait for window signal
        WaitForSingleObject(m_event,INFINITE);

        // check window handle
        if (!IsWindow(m_window)) throw Error("could not create window");
    }
    catch (Error error)
    {
        // close
        close();

        // error message
        error.rethrow("could not create window");
    }
}


Window::~Window()
{
    // close
    close();
}




HWND Window::handle()
{
    // get handle
    return m_window;
}


DWORD Window::thread()
{
    // get thread id
    return m_id;
}




void Window::defaults()
{
    // defaults
    m_window = 0;
    m_cursor = 0;
    m_event = 0;
    m_thread = 0;
    m_id = 0;
}


void Window::close()
{
    // check window and thread
    if (m_thread && IsWindow(m_window))
    {
        // close window
        PostMessage(m_window,WM_DESTROY,0,0);

        // wait for window thread to exit
        WaitForSingleObject(m_thread,INFINITE);
    }

    // release objects
    if (m_event)  CloseHandle(m_event);
    if (m_thread) CloseHandle(m_thread);

    // destroy cursor
    if (m_cursor) DestroyCursor(m_cursor);

    // set normal priority class
    SetPriorityClass(GetCurrentProcess(),NORMAL_PRIORITY_CLASS);
}




void WINAPI Window::ThreadFunction(Window *owner)
{
    // create window
    owner->m_window = CreateWindowEx(owner->extra,owner->name,owner->title,owner->style,owner->x,owner->y,owner->width,owner->height,0,0,0,owner->data);
    
    // check window handle
    if (IsWindow(owner->m_window))
    {
        // show window
        ShowWindow(owner->m_window,owner->show);

        // set window focus
        SetFocus(owner->m_window);

        // set foreground window
        SetForegroundWindow(owner->m_window);

        // signal window event
        SetEvent(owner->m_event);

        // message loop
        MSG message;
        while (GetMessage(&message,0,0,0)==TRUE)
        {
            // process window message
            TranslateMessage(&message);
            DispatchMessage(&message);
        }
    }
    else
    {
        // window failure
        SetEvent(owner->m_event);
    }
}


LRESULT CALLBACK Window::WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
    // result data
    int result = 0;

    // handle message
    switch (message)
    {
        //
        // NOTE: this is a temporary hack because the win32 hook is failing
        // when more than one hook is installed!
        //
        case WM_DIRECTX_OPEN:
        {
            // setup message data
            Display::Data *data = (Display::Data*)wParam;
            bool *result = (bool*)lParam;
            
            try
            {
                // open display
                data->display->open(hWnd,data->title,data->width,data->height,*data->format);

                // success
                *result = true;
            }
            catch (Error&)
            {
                // failure
                *result = false;
            }
        }
        break;

        case WM_DIRECTX_CLOSE:
        {
            // setup message data
            Display::Data *data = (Display::Data*)wParam;

            try
            {
                // close display
                if (data->display) data->display->close();
            }
            catch (Error&)
            {
                // no exceptions thanks...
            }
        }
        break;

        case WM_DESTROY:
        {
            // shutdown window
            PostQuitMessage(0);
        }
        break;

        case WM_CLOSE:
        {
            // exit
            exit(0);
        }
    
        default:
        {
            // unhandled messages
            result = DefWindowProc(hWnd,message,wParam,lParam);
        }
    }

    // return value
    return result;
}
