//
// Core Error class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_CORE_ERROR_H
#define __PTC_CORE_ERROR_H

// include files
#include "Base/Error.h"




namespace ptc
{
    namespace Core
    {
        class Error : public Base::Error
        {
            public:

                // constructor
                Error(const char message[]);

                // rethrow error
                virtual void rethrow(const char message[]);

                // report
                virtual void report() const;

                // data access
                virtual const char* message() const;

            private:

                // error message
                char m_message[1024];
        };
    }
}





#endif
