//
// Core Error implementation for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include <windows.h>
#include "Core/Error.h"

// using directive
using namespace ptc::Core;




Error::Error(const char message[])
{
    // set error message
    strcpy(this->m_message,message);
}




void Error::rethrow(const char message[])
{
    // rethrow
    throw *this;
}




void Error::report() const
{
    // report error
    MessageBox(0,m_message,"Error",MB_OK | MB_ICONERROR | MB_SETFOREGROUND | MB_TOPMOST);

    // exit
    exit(1);
}




const char* Error::message() const
{
    // get message
    return m_message;
}
