/*
   Pixel format structure operations for the HERMES library
   Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
   This source code is licensed under the GNU LGPL
  
   Please refer to the file COPYING.LIB contained in the distribution for
   licensing conditions
*/

#include <stdlib.h>
#include <string.h>
#include "H_Format.h"



HermesFormat *Hermes_FormatNewEmpty()
{ HermesFormat *tmp;

  tmp=(HermesFormat *)malloc(sizeof(HermesFormat));
  if (!tmp) return 0;

  tmp->bits=0;
  tmp->indexed=0;
  tmp->r=0;
  tmp->g=0;
  tmp->b=0;
  tmp->a=0;

  return tmp;
}

HermesFormat *Hermes_FormatNew(int bits,int32 r,int32 g,int32 b,int32 a,
			       char indexed)
{ HermesFormat *tmp;

  /* Indexed has to be 8 bit */
  if (indexed && bits!=8) return 0;
 
  tmp=(HermesFormat *)malloc(sizeof(HermesFormat)); 
  if (!tmp) return 0;

  tmp->bits=bits;
  tmp->r=r;
  tmp->g=g;
  tmp->b=b;
  tmp->a=a;
  tmp->indexed=indexed;

  return tmp;
}


/* Compare two formats. Return 1 if they are equal, 0 otherwise */
char Hermes_FormatEquals(HermesFormat *op1,HermesFormat *op2)
{ 
  if (!op1 || !op2) return 0;

  /*  return !memcmp(op1,op2,sizeof(HermesFormat)); */
 
  return (op1->indexed == op2->indexed &&
	  op1->bits == op2->bits &&
	  op1->r == op2->r &&
	  op1->g == op2->g &&
	  op1->b == op2->b &&
	  op1->a == op2->a);
}


void Hermes_FormatCopy(HermesFormat *source,HermesFormat *dest)
{
  memcpy(dest,source,sizeof(HermesFormat));
}
