//
// Core Format class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_CORE_FORMAT_H
#define __PTC_CORE_FORMAT_H

// include files
#include "Core/Index.h"
#include "Base/Format.h"




namespace ptc
{
    namespace Core
    {
        class Format : public Base::Format
        {
            public:

                // setup
                Format();
                Format(int bits);
                Format(int bits,int32 r,int32 g,int32 b,int32 a=0);
                Format(const Base::Format &other);

                // data access
                virtual int32 r() const;
                virtual int32 g() const;
                virtual int32 b() const;
                virtual int32 a() const;
                virtual int bits() const;
                virtual bool direct() const;
                virtual bool indexed() const;

                // operators
                Format& operator =(const Format &other);
                virtual Base::Format& operator =(const Base::Format &other);
                virtual bool operator ==(const Base::Format &other) const;
                virtual bool operator !=(const Base::Format &other) const;

            private:

                // data
                int m_bits;
                int32 m_r;
                int32 m_g;
                int32 m_b;
                int32 m_a;
                bool m_direct;
                bool m_indexed;
        };
    }
}




#endif
