//
// Core Console implementation for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include "Core/Error.h"
#include "Core/Console.h"
#include "DirectX/Console.h"

// using directive
using namespace ptc::Core;

// using declarations
using ptc::Core::Error;




Console::Console()
{
    // defaults
    console = 0;
}


Console::Console(const char title[],int width,int height,const ptc::Base::Format &format)
{
    // defaults
    console = 0;

    // open console
    open(title,width,height,format);
}


Console::~Console()
{
    // close
    close();
}




void Console::open(const char title[],int width,int height,const ptc::Base::Format &format)
{
    try
    {
        // close
        close();
        
        // create new console
        console = new ptc::DirectX::Console(title,width,height,format);
    }
    catch (Error &error)
    {
        // close
        close();

        // error message
        error.rethrow("could not open console");
    }
}


void Console::close()
{
    // close console
    delete console;
    console = 0;
}




void Console::update()
{
    // update console
    console->update();
}




bool Console::key()
{
    // check for keypress
    return console->key();
}


int Console::read()
{
    // read keypress
    return console->read();
}




void Console::copy(ptc::Base::Surface &surface)
{
    // copy console to surface
    console->copy(surface);
}


void Console::copy(ptc::Base::Surface &surface,const ptc::Base::Area &source,const ptc::Base::Area &destination)
{
    // copy console to surface
    console->copy(surface,source,destination);
}




void* Console::lock()
{
    // lock console
    return console->lock();
}


void Console::unlock()
{
    // unlock console
    console->unlock();
}




void Console::load(const void *pixels,int width,int height,const ptc::Base::Format &format,const int32 palette[])
{
    // load pixels to console
    console->load(pixels,width,height,format,palette);
}


void Console::load(const void *pixels,int width,int height,const ptc::Base::Format &format,const int32 palette[],const ptc::Base::Area &area)
{
    // load pixels to console
    console->load(pixels,width,height,format,palette,area);
}




void Console::save(void *pixels,int width,int height,const ptc::Base::Format &format,const int32 palette[]) const
{
    // save console pixels
    console->save(pixels,width,height,format,palette);
}


void Console::save(void *pixels,int width,int height,const ptc::Base::Format &format,const int32 palette[],const ptc::Base::Area &area) const
{
    // save console pixels
    console->save(pixels,width,height,format,palette,area);
}




void Console::palette(const int32 palette[])
{
    // set console palette
    console->palette(palette);
}




int Console::width()
{
    // get width
    return console->width();
}


int Console::height()
{
    // get height
    return console->height();
}


int Console::pitch()
{
    // get pitch
    return console->pitch();
}


const ptc::Base::Format& Console::format()
{
    // get format
    return console->format();
}


const char* Console::name()
{
    // get name
    return console->name();
}
