//
// Copy interface for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

// package name
package ptc.base;

// class imports
import ptc.Error;
import ptc.Color;
import ptc.Format;
import ptc.Palette;



public interface Copy
{
    // request conversion between pixel formats
    public void request(Format source,Format destination) throws Error;
    
    // set conversion palettes
    public void palette(Palette source,Palette destination) throws Error;
    
    // copy pixels
    public void copy(Object source_pixels,int source_x,int source_y,int source_width,int source_height,int source_pitch,Object destination_pixels,int destination_x,int destination_y,int destination_width,int destination_height,int destination_pitch) throws Error;
    
    // copy option string
    public boolean option(String option) throws Error;
}
