//
// Timer test for OpenPTC 1.0 C++ Implementation
// Copyright (c) Glenn Fiedler (ptc@gaffer.org)
// This source code is in the public domain
//

// include files
#include "ptc.h"
#include <time.h>
#include <stdio.h>


void main()
{
    try
    {
        // create timer
        Timer timer;

        // loop repeat count
        const count = 10000;

        // start timer
        timer.start();
        
        // get current time
        double time = timer.time();
        double old = time;
        
        // main timer loop
        for (int i=0; i<count; i++)
        {
            // get current timer data
            const double time  = timer.time();
            const double delta = timer.delta();

            // check that new time is never less than old time
            if (time<old) throw Error("new time was less than old time!");

            // update old time
            old = time;
                        
            // print timer data
            printf("timer is running: %f seconds [delta %f]\n",time,delta);

            // check delta is positive
            if (delta<0.0) throw Error("timer delta was negative!");
        }

        // check that the time has changed since we started the timer
        if (timer.time()==0.0) throw Error("failed Timer::start test");

        // stop timer
        timer.stop();

        // save old time value
        const double old_time = timer.time();
        
        // make sure that when the timer is stopped delta is zero and time does not change
        for (int j=0; j<count; j++)
        {
            // get timer data
            const double time  = timer.time();
            const double delta = timer.delta();

            // print timer data
            printf("timer is stopped: %f seconds [delta %f]\n",time,delta);

            // check timer data
            if (time!=old_time || delta!=0.0) throw Error("failed Timer::stop test");
        }

        // set the timer
        timer.set(10.0);

        // check that the set worked
        if (timer.time()!=10.0) throw Error("failed Timer::set test!");

        // the timer implementation has passed the test
        printf("\n\ncongratulations you passed the timer test!\n\n");
        printf("the timer resolution is %f seconds\n\n",timer.resolution());

        // check if timer resolution matches <time.h>
        if (timer.resolution()==1.0/(double)CLOCKS_PER_SEC)
        {
            // upgrade your timer implementation!
            printf("WARNING: The timer resolution is 1/CLOCKS_PER_SECOND.\n");
            printf("This indicates that you are using the time functions from <time.h>\n");
            printf("Upgrade your timer class to use higher resolution time functions!\n\n");
        }
    }
    catch (Error &error)
    {
        // report error
        error.report();
    }
}
