//
// Win32 Keyboard class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include "Win32/Keyboard.h"

// using directive
using namespace ptc::Win32;




Keyboard::Keyboard(HWND window,DWORD thread) : Hook(window,thread)
{
    // defaults
    m_key = false;
}


Keyboard::~Keyboard()
{
    // destructor
}




bool Keyboard::key()
{
    // get key
    monitor.enter();
    bool key = m_key;
    monitor.leave();
    return key;
}


int Keyboard::read()
{
    // read key
    return 0;
}




LRESULT CALLBACK Keyboard::WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
    // handle key message
    if (message==WM_KEYDOWN)
    {
        // set key flag
        monitor.enter();
        m_key = true;
        monitor.leave();
    }

    // done
    return 0;
}
