//
// Core Area implementation for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include "Core/Area.h"
#include "Core/Error.h"

// using directive
using namespace ptc::Core;

// using declarations
using ptc::Core::Error;




Area::Area()
{
    // defaults
    m_left   = 0;
    m_top    = 0;
    m_right  = 0;
    m_bottom = 0;
}


Area::Area(int left,int top,int right,int bottom)
{
    // check area data
    if (left>right || top>bottom) throw Error("invalid area");

    // setup data
    m_left   = left;
    m_top    = top;
    m_right  = right;
    m_bottom = bottom;
}


Area::Area(const ptc::Base::Area &other)
{
    // assignment
    *this = other;
}




int Area::left() const
{
    // get left
    return m_left;
}


int Area::right() const
{
    // get right
    return m_right;
}


int Area::top() const
{
    // get top
    return m_top;
}


int Area::bottom() const
{
    // get bottom
    return m_bottom;
}


int Area::width() const
{
    // get width
    return m_right-m_left;
}


int Area::height() const
{
    // get height
    return m_bottom-m_top;
}




Area& Area::operator =(const Area &other)
{
    // assignment
    m_left   = other.m_left;
    m_top    = other.m_top;
    m_right  = other.m_right;
    m_bottom = other.m_bottom;
    return *this;
}


ptc::Base::Area& Area::operator =(const ptc::Base::Area &other)
{
    // assignment
    m_left   = other.left();
    m_top    = other.top();
    m_right  = other.right();
    m_bottom = other.bottom();
    return *this;
}


bool Area::operator ==(const ptc::Base::Area &other) const
{
    // is equal to
    if (m_left==other.left() && m_top==other.top() && m_right==other.right() && m_bottom==other.bottom()) return true;
    else return false;
}


bool Area::operator !=(const ptc::Base::Area &other) const
{
    // not equal to
    return !(*this==other);
}
