//
// Palette example: demonstrates palette setting
// Copyright (c) Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU GPL
//

// include files
#include "ptc.h"




int APIENTRY WinMain(HINSTANCE hInst,HINSTANCE hPrevInst,LPSTR lpCmdLine,int nCmdShow)
{
    try
    {
        // create format
        Format format(8);

        // create console
        Console console("Palette example",320,200,format);

        // create surface
        Surface surface(320,200,format);
        
        // generate palette
        int32 palette[256];
        for (int i=0; i<256; i++) palette[i] = i;

        // set console palette
        console.palette(palette);
        
        // set surface palette
        surface.palette(palette);

        // loop until a key is pressed
        while (!console.key())
        {
            // lock surface
            char8 *pixels = (char8*) surface.lock();

            // draw random pixels
            for (int i=0; i<100; i++)
            {
                // get random position
                int x = random(320);
                int y = random(200);

                // get random color index
                char8 index = random(256);

                // draw color [index] at position [x,y]
                pixels[x+y*320] = index;
            }
        
            // unlock surface
            surface.unlock();

            // copy to console
            surface.copy(console);

            // update console
            console.update();
        }

        // done
        return 0;
    }
    catch (Error &error)
    {
        // report error
        error.report();
    }
}
