//
// RNI Copy class for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

// package name
package ptc.rni;

// class imports
import ptc.Error;
import ptc.Color;
import ptc.Format;
import ptc.Palette;



public class Copy implements ptc.base.Copy
{
    public Copy() throws Error
    {
        // create object
        object = create();
    }
    
    protected void finalize() throws Error
    {
        // destroy object
        destroy(object);
    }

    public void request(Format source,Format destination) throws Error
    {
        // request conversion
        request(object,source,destination);
    }

    public void palette(Palette source,Palette destination) throws Error
    {
        // set palettes
        palette(object,source,destination);
    }

    public void copy(Object source_pixels,int source_x,int source_y,int source_width,int source_height,int source_pitch,Object destination_pixels,int destination_x,int destination_y,int destination_width,int destination_height,int destination_pitch) throws Error
    {
        // copy pixels
        copy(object,source_pixels,source_x,source_y,source_width,source_height,source_pitch,destination_pixels,destination_x,destination_y,destination_width,destination_height,destination_pitch);
    }

    public boolean option(String option) throws Error
    {
        // copy option
        return option(object,option);
    }

    // object handle
    private long object;

    // native methods
    private native long create() throws Error;
    private native void destroy(long object) throws Error;
    private native void request(long object,Format source,Format destination) throws Error;
    private native void palette(long object,Palette source,Palette destination) throws Error;
    private native void copy(long object,Object source_pixels,int source_x,int source_y,int source_width,int source_height,int source_pitch,Object destination_pixels,int destination_x,int destination_y,int destination_width,int destination_height,int destination_pitch) throws Error;
    private native boolean option(long object,String option) throws Error;
}
