//
// Area class for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

// package
package ptc;



public class Area implements Cloneable
{
    public Area()
    {
        // defaults
        left = 0;
        top = 0;
        right = 0;
        bottom = 0;
    }

    public Area(int left,int top,int right,int bottom)
    {
        // setup x data
        if (left<right)
        {
            // assign
            this.left  = left;
            this.right = right;
        }
        else
        {
            // switch left & right
            this.left  = right;
            this.right = left;
        }

        // setup y data
        if (top<bottom)
        {
            // assign
            this.top    = top;
            this.bottom = bottom;
        }
        else
        {
            // switch top & bottom
            this.top    = bottom;
            this.bottom = top;
        }
    }

    public int left()
    {
        // get left
        return left;
    }

    public int right()
    {
        // get right
        return right;
    }

    public int top()
    {
        // get top
        return top;
    }

    public int bottom()
    {
        // get bottom
        return bottom;
    }

    public int width()
    {
        // get width
        return right-left;
    }

    public int height()
    {
        // get height
        return bottom-top;
    }

    public Area copy()
    {
        try
        {
            // clone area object
            return (Area) clone();
        }
        catch (CloneNotSupportedException e)
        {
            // failure
            return null;
        }
    }

    public boolean compare(Area area)
    {
        // compare area data
        if (left==area.left && top==area.top && right==area.right && bottom==area.bottom) return true;
        else return false;
    }

    // area data
    protected int left;
    protected int top;
    protected int right;
    protected int bottom;
}
