//
// Modes example for OpenPTC 1.0 Java Implementation
// Copyright (c) Glenn Fiedler (ptc@gaffer.org)
// This source code is in the public domain
//

// import classes
import ptc.Mode;
import ptc.Error;
import ptc.Format;
import ptc.Console;



class Modes
{
    public static void main(String argv[])
    {
        try
        {
            // create console
            Console console = new Console();
        
            // get list of console modes
            Mode modes[] = console.modes();

            // check for empty list
            if (!modes[0].valid())
            {
                // the console mode list was empty
                System.out.println("[console mode list is not available]");
            }
            else
            {
                // print mode list header
                System.out.println("[console modes]");

                // mode index
                int index = 0;

                // iterate through all modes
                while (modes[index].valid())
                {
                    // print mode
                    print(modes[index]);

                    // next mode
                    index ++;
                }
            }

            // close console
            console.close();
        }
        catch (Error error)
        {
            // report error
            error.report();
        }

        // exit program
        System.exit(0);
    }

    static void print(Format format) throws Error
    {
        // check format type
        if (format.direct())
        {
            // check alpha
            if (format.a()==0)
            {
                // direct color format without alpha
                System.out.print("Format(" + format.bits() + "," + format.r() + "," + format.g() + "," + format.b() + ")");
            }
            else
            {
                // direct color format with alpha
                System.out.print("Format(" + format.bits() + "," + format.r() + "," + format.g() + "," + format.b() + "," + format.a() + ")");
            }
        }
        else
        {
            // indexed color format
            System.out.print("Format(" + format.bits() + ")");
        }
    }

    static void print(Mode mode) throws Error
    {
        // print mode width and height
        System.out.print(" " + mode.width() + " x " + mode.width() + " x ");

        // print mode format
        print(mode.format());

        // newline
        System.out.println();
    }
}

