#ifndef __PTC_X11_WINDOW_DISPLAY_H
#define __PTC_X11_WINDOW_DISPLAY_H


#include <X11/Xlib.h>
#include "ptconfig.h"
#include "Display.h"
#include "Core/Key.h"

class Palette;
class Format;
class Area;
class X11Display;



class X11WindowDisplay : public X11Display {
public:
  X11WindowDisplay();
  ~X11WindowDisplay();

  virtual void open(const char title[],int width,int height,
		    const Format& format,Display *disp,int screen);
  virtual void open(Display *disp,int screen,Window w,const Format &format);
  virtual void open(Display *disp,int screen,Window window,
		    const Format& format,int x,int y,int w,int h);

  virtual void close();

  virtual void update();
  virtual void update(const Area &area);

  virtual bool key();
  virtual Key read();

  virtual void* lock();
  virtual void unlock();

  virtual void palette(const Palette &palette);

  virtual int pitch() const;


  // X11 convenience functions 
  virtual Window getX11Window() const { return m_window; }
  virtual GC getX11GC() const { return m_gc; }

private:
  X11Image *createImage(Display *disp,int screen,int width,int height,
			Format &format);           // Factory method

  void createColormap();                           // Register colour maps

  static void* eventHandler(void *);               // Event handler thread

  Window m_window;

  X11Image *m_primary;
  int m_destx,m_desty;
  GC m_gc;

  Atom m_atom_close;        // X Atom for close window button

  bool m_keypressed;        // Key pressed since the last call to key() ? 
  Key m_keylast;   // Last key pressed (scancode)
};



#endif

