#ifndef __PTC_X11DGADISPLAY_H
#define __PTC_X11DGADISPLAY_H


#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "ptconfig.h"


class Palette;
class Format;
class X11Display;
class Area;



#ifdef HAVE_DGA

#include <X11/extensions/xf86vmode.h>

class X11DGADisplay : public X11Display {
public:
  X11DGADisplay();

  ~X11DGADisplay();

  virtual void open(const char title[],int width,int height,
		    const Format& format,Display *disp,int screen);
  // Not in DGA mode
  virtual void open(Display *disp,int screen,Window w,const Format& format) 
  { if(disp==0); // Prevent warnings
    if(screen==0);
    if(w==0);
    if(format==Format(8));
  }

  virtual void open(Display *disp,int screen,Window window,
		    const Format& format,int x,int y,int w,int h) 
  { if(disp==0 || screen==0 || window==0 || format==Format(8) || x==0 ||
       y==0 || w==0 || h==0);
  }

  virtual void close();

  virtual void update();
  virtual void update(const Area &area) { update(); }

  virtual void* lock();
  virtual void unlock();

  virtual bool key();
  virtual Key read();

  virtual void palette(const Palette &palette);

  virtual int pitch() const;

  // return root for window
  virtual Window getX11Window() const { return DefaultRootWindow(m_disp); }
  
private:
  XF86VidModeModeInfo **modeinfo;
  int num_modeinfo;
  int previousmode;
  
  char *dga_addr;
  int dga_linewidth;
  int dga_banksize;
  int dga_memsize;
  int dga_width,dga_height;

  // Coordinates of upper left frame corner
  int m_destx,m_desty;

  bool m_indirect,m_inmode;
};



#else


class X11DGADisplay : public X11Display {
public:
  static bool check(int width,int height,Display *disp,int screen,long flags)
  { return false;
  }

  virtual void open(const char title[],int width,int height,
		    const Format& format,Display *disp,int screen) {}

  virtual void open(Display *disp,int screen,Window w,const Format& format) 
  { if(disp==0); // Prevent warnings
    if(screen==0);
    if(w==0);
    if(format==Format(8));
  }

  virtual void open(Display *disp,int screen,Window window,
		    const Format& format,int x,int y,int w,int h) 
  { if(disp==0 || screen==0 || window==0 || format==Format(8) || x==0 ||
       y==0 || w==0 || h==0);
  }

  virtual void close() {}

  virtual void update() {}
  virtual void update(const Area &area) {}

  virtual void* lock() {}
  virtual void unlock() {}

  virtual bool key() { return false; }
  virtual Key read() { Key s; return s; }

  virtual void palette(const Palette &palette) {}

  virtual int pitch() const { return 0; }

  // return root for window
  virtual Window getX11Window() const { return 0; }
  
};



#endif  // HAVE_DGA



#endif
