//
// Tiny Surface class for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// package name
package tinyptc;



public class Surface
{
    public Surface(int width,int height,Format format)
    {
        // setup data
        this.width  = width;
        this.height = height;
        this.format = format;

        // calculate surface size
        final int size = width * height;

        // allocate pixels
        switch (format.bits())
        {
            case 8:  pixels = new byte[size]; break;
            case 32: pixels = new int[size];  break;
        }
    }

    public void copy(Console console)
    {
        // load surface pixels to console
        console.load(pixels,width,height,width*format.bytes(),format,palette);
    }

    public Object lock()
    {
        // lock surface
        return pixels;
    }

    public void unlock()
    {
    }

    public void palette(Palette palette)
    {
        // get surface palette
        Palette p = this.palette;

        // load palette data
        p.load(palette.data());
    }

    public int width()
    {
        // get width
        return width;
    }

    public int height()
    {
        // get height
        return height;
    }

    public Format format()
    {
        // get format
        return format;
    }

    // surface data
    private int width;
    private int height;
    private Format format;
    private Object pixels;
    private Palette palette = new Palette();
}
