//
// Tiny Applet class for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// package name
package tinyptc;

// import classes
import java.awt.Color;
import java.awt.Graphics;



public abstract class Applet extends java.applet.Applet implements Runnable
{
    // abstract ptc applet methods
    public abstract Console create();
    public abstract void run(Console console);

    public void init()
    {
        // set black background
        setBackground(Color.black);
    }

    public void start()
    {
        // check thread
        if (thread==null)
        {
            // create thread
            thread = new Thread(this);

            // start thread
            thread.start();
        }
    }

    public void run()
    {
        // user create console
        console = create();

        // user run
        run(console);
    }

    public void destroy()
    {
        // stop thread
        thread.stop();

        // null thread
        thread = null;
    }
    
    public void paint(Graphics graphics)
    {
        // check console
        if (console!=null)
        {
            // update console
            console.update();
        }
    }

    // applet data
    private Thread thread;
    private Console console;
}
