//
// Java Model class for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// package name
package ptc.java;

// import classes
import ptc.Error;
import ptc.Format;
import ptc.Palette;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.DirectColorModel;



public class Model
{
    public Model(Format format)
    {
        // allocate color model
        if (format.direct())
        {
            // create direct color model
            model = new DirectColorModel(format.bits(),format.r(),format.g(),format.b(),format.a());
        }
        else if (format.indexed())
        {
            // create data byte array
            byte data[] = new byte[256];
            
            // clear data byte array
            for (int i=0; i<256; i++) data[i] = 0;

            // create indexed color model
            model = new IndexColorModel(format.bits(),256,data,data,data);
        }
 }

    public Model(Format format,Palette palette)
    {
        // get palette data array
        int data[] = palette.data();

        // create color arrays
        byte r[] = new byte[256];
        byte g[] = new byte[256];
        byte b[] = new byte[256];
        byte a[] = new byte[256];

        // setup color byte arrays
        for (int i=0; i<256; i++)
        {
            // unpack color integer to a,r,g,b
            r[i] = (byte) ( (data[i] & 0x00FF0000) >> 16 );
            g[i] = (byte) ( (data[i] & 0x0000FF00) >> 8  );
            b[i] = (byte) ( (data[i] & 0x000000FF)       );
        }

        // create indexed color model
        model = new IndexColorModel(format.bits(),256,r,g,b);
    }
    
    public ColorModel model()
    {
        // get model
        return model;
    }

 // model data
    ColorModel model;
}
