//
// Error class for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// package
package ptc;

// import classes
import java.util.Vector;
import java.util.Enumeration;



public class Error extends Exception implements Cloneable
{
    public Error(String message)
    {
        // set message
        super(message);
    }

    public Error(String message,Error error)
    {
        // set compound error message
        super(message+"\n"+error.message());
    }

    public void report()
    {
        // iteratate through registered consoles
        Enumeration enum = consoles.elements();
     while (enum.hasMoreElements()) 
        {   
            // get base console object from list
            ptc.base.Console console = (ptc.base.Console) enum.nextElement();

            try
            {
                // close console
                console.close();
            }
            catch (Error error)
            {
                // no exceptions
            }
  }

        // report error
        System.err.println("error: " + getMessage());

        try
        {
            // exit program
            System.exit(1);
        }
        catch (Throwable error)
        {
            // could not exit... applet?
        }
    }

    public String message()
    {
        // get error message
        return getMessage();
    }

    public Error copy()
    {
        try
        {
            // clone error object
            return (Error) clone();
        }
        catch (CloneNotSupportedException e)
        {
            // failure
            return null;
        }
    }

    public boolean compare(Error error)
    {
        // compare error message
        return getMessage().equals(error.getMessage());
    }

    public static synchronized void register(ptc.base.Console console)
    {
        // check if already registered
     if (consoles.contains(console)) return;

        // register console
        consoles.addElement(console);
    }

    public static synchronized void unregister(ptc.base.Console console)
    {
        // unregister console
        consoles.removeElement(console);
    }

    // error data
    private static Vector consoles = new Vector();
}
